"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var api_definition_1 = require("@gk-app-enablement/api-definition");
var GkMessagingApi_1 = require("./GkMessagingApi");
var FunctionMessagingApi = (function (_super) {
    __extends(FunctionMessagingApi, _super);
    function FunctionMessagingApi(sendMessage) {
        return _super.call(this, sendMessage, api_definition_1.FunctionApi.apiName) || this;
    }
    FunctionMessagingApi.prototype.registerCloseInterceptor = function (closeInterceptor) {
        var _this = this;
        var wrapperFunction = function () {
            closeInterceptor()
                .then(function () {
                _this.sendMessage({
                    resourceApi: api_definition_1.FunctionApi.apiName,
                    resourceMethod: "acceptCloseFunctionRequest",
                });
            }, function () {
                if (console) {
                    console.error('FunctionMessagingApi:: close interceptor rejects close. Function won\'t be closed!!');
                }
                _this.sendMessage({
                    resourceApi: api_definition_1.FunctionApi.apiName,
                    resourceMethod: "rejectCloseFunctionRequest",
                });
            })
                .catch(function () {
                if (console) {
                    console.error('FunctionMessagingApi::error during resolving close interceptor. Function will be closed!!');
                }
                _this.sendMessage({
                    resourceApi: api_definition_1.FunctionApi.apiName,
                    resourceMethod: "acceptCloseFunctionRequest",
                });
            });
        };
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "registerCloseInterceptor",
            callback: wrapperFunction,
            isEventRegistration: true
        });
    };
    FunctionMessagingApi.prototype.getFunctionContext = function (appCallback) {
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "getFunctionContext",
            callback: appCallback,
        });
    };
    FunctionMessagingApi.prototype.getFunctionCache = function (appCallback, data) {
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "getFunctionCache",
            callback: appCallback,
            data: data
        });
    };
    FunctionMessagingApi.prototype.setFunctionCache = function (appCallback, data) {
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "setFunctionCache",
            callback: appCallback,
            data: data
        });
    };
    FunctionMessagingApi.prototype.closeFunction = function () {
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "closeFunction"
        });
    };
    FunctionMessagingApi.prototype.launchFunction = function (functionContext) {
        this.sendMessage({
            resourceApi: api_definition_1.FunctionApi.apiName,
            resourceMethod: "launchFunction",
            data: functionContext
        });
    };
    return FunctionMessagingApi;
}(GkMessagingApi_1.GkMessagingApi));
exports.FunctionMessagingApi = FunctionMessagingApi;
