"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var api_definition_1 = require("@gk-app-enablement/api-definition");
var GkMessagingApi_1 = require("./GkMessagingApi");
var CommonMessagingApi = (function (_super) {
    __extends(CommonMessagingApi, _super);
    function CommonMessagingApi(sendMessage, cancelMessageListening) {
        var _this = _super.call(this, sendMessage, api_definition_1.CommonApi.apiName) || this;
        _this.cancelMessageListening = cancelMessageListening;
        return _this;
    }
    CommonMessagingApi.prototype.getLocaleSettings = function (appCallback) {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "getLocaleSettings",
            callback: appCallback,
        });
    };
    CommonMessagingApi.prototype.getSessionContext = function (appCallback) {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "getSessionContext",
            callback: appCallback,
        });
    };
    CommonMessagingApi.prototype.registerListener = function (eventHandler, eventName, registrationId, expectData) {
        if (expectData === void 0) { expectData = false; }
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "registerListener",
            callback: eventHandler,
            customId: registrationId,
            isEventRegistration: true,
            data: {
                event: eventName,
                listener: registrationId,
                passData: expectData,
                staticListener: true
            }
        });
    };
    CommonMessagingApi.prototype.unregisterListener = function (eventName, registrationId) {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "unregisterListener",
            customId: registrationId,
            data: {
                event: eventName
            }
        });
        this.cancelMessageListening(registrationId);
    };
    CommonMessagingApi.prototype.closeBrowser = function () {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "closeBrowser",
        });
    };
    CommonMessagingApi.prototype.hideBrowser = function () {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "hideBrowser"
        });
    };
    CommonMessagingApi.prototype.getOperatorData = function (appCallback) {
        this.sendMessage({
            resourceApi: api_definition_1.CommonApi.apiName,
            resourceMethod: "getOperatorData",
            callback: appCallback,
        });
    };
    return CommonMessagingApi;
}(GkMessagingApi_1.GkMessagingApi));
exports.CommonMessagingApi = CommonMessagingApi;
