"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Apis = __importStar(require("@gk-app-enablement/api-definition"));
var AppEnablement_1 = require("../AppEnablement");
var AuthorizationMessagingApi_1 = require("./messagingApis/AuthorizationMessagingApi");
var CommonMessagingApi_1 = require("./messagingApis/CommonMessagingApi");
var ExternalMasterDataMessagingApi_1 = require("./messagingApis/ExternalMasterDataMessagingApi");
var FunctionMessagingApi_1 = require("./messagingApis/FunctionMessagingApi");
var PosMessagingApi_1 = require("./messagingApis/PosMessagingApi");
var MasterDataMessagingApi_1 = require("./messagingApis/MasterDataMessagingApi");
var ScannerMessagingApi_1 = require("./messagingApis/ScannerMessagingApi");
var MessagingMessagingApi_1 = require("./messagingApis/MessagingMessagingApi");
var FuelMessagingApi_1 = require("./messagingApis/FuelMessagingApi");
var AppEnablementMessaging = (function (_super) {
    __extends(AppEnablementMessaging, _super);
    function AppEnablementMessaging() {
        var _this = _super.call(this) || this;
        _this.windowAsAny = window;
        _this.availableApiList = {};
        _this.callbackQueue = {};
        _this.listenersMap = {};
        _this.registerApis();
        _this.windowAsAny.addEventListener("message", _this.handlePostMessage.bind(_this), false);
        return _this;
    }
    AppEnablementMessaging.prototype.registerApis = function () {
        this.availableApiList[Apis.MasterDataApi.apiName] = new MasterDataMessagingApi_1.MasterDataMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.ExternalMasterDataApi.apiName] = new ExternalMasterDataMessagingApi_1.ExternalMasterDataMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.PosApi.apiName] = new PosMessagingApi_1.PosMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.CommonApi.apiName] = new CommonMessagingApi_1.CommonMessagingApi(this.registerCallForMessage.bind(this), this.unRegisterListener.bind(this));
        this.availableApiList[Apis.AuthorizationApi.apiName] = new AuthorizationMessagingApi_1.AuthorizationMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.FunctionApi.apiName] = new FunctionMessagingApi_1.FunctionMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.ScannerApi.apiName] = new ScannerMessagingApi_1.ScannerMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.MessagingApi.apiName] = new MessagingMessagingApi_1.MessagingMessagingApi(this.registerCallForMessage.bind(this));
        this.availableApiList[Apis.FuelApi.apiName] = new FuelMessagingApi_1.FuelMessagingApi(this.registerCallForMessage.bind(this));
    };
    AppEnablementMessaging.prototype.registerCallForMessage = function (data) {
        var eventID;
        if (data.customId && data.customId.length > 0) {
            eventID = data.customId;
        }
        else {
            eventID = "GK_" + data.resourceMethod + "_" + data.resourceApi + "_" + new Date().getTime();
        }
        if (data.callback) {
            if (data.isEventRegistration) {
                this.listenersMap[eventID] = data.callback;
            }
            else {
                this.callbackQueue[eventID] = data.callback;
            }
        }
        this.sendMessageToEnvelope(eventID, data);
    };
    AppEnablementMessaging.prototype.unRegisterListener = function (eventId) {
        if (this.listenersMap.hasOwnProperty(eventId)) {
            delete this.listenersMap[eventId];
        }
    };
    AppEnablementMessaging.prototype.getUrlParameter = function (parameterName) {
        var sResult = "", aTmp = null, aItems = window.location.search.substr(1).split("&"), index = 0, iItemsLength = (aItems) ? aItems.length : 0;
        for (index; index < iItemsLength; index++) {
            aTmp = aItems[index].split("=");
            if (aTmp[0] === parameterName) {
                sResult = decodeURIComponent(aTmp[1]);
            }
        }
        return sResult;
    };
    ;
    AppEnablementMessaging.prototype.sendMessageToEnvelope = function (eventId, data) {
        var appToken = this.getUrlParameter("appToken");
        var apiCall = {
            id: eventId,
            resourceMethod: data.resourceMethod,
            resourceApi: data.resourceApi,
            data: data.data,
            discriminator: Apis.EventApiCallDiscriminator.EVENT_API_CALL,
            token: appToken
        };
        parent.postMessage(apiCall, "*");
    };
    AppEnablementMessaging.prototype.handlePostMessage = function (event) {
        var eventData = event.data;
        switch (event.data["discriminator"]) {
            case Apis.EventApiCallDiscriminator.EVENT_API_RESPONSE: {
                var callback = this.getCallback(eventData.id, this.callbackQueue);
                delete this.callbackQueue[eventData.id];
                callback(eventData.data);
                break;
            }
            case Apis.EventApiCallDiscriminator.EVENT_API_TRIGGERED_RESPONSE: {
                var callback = this.getCallback(eventData.id, this.listenersMap);
                callback(eventData.data);
                break;
            }
        }
    };
    AppEnablementMessaging.prototype.getCallback = function (id, queue) {
        if (queue.hasOwnProperty(id)) {
            return queue[id];
        }
        else
            return function () { };
    };
    AppEnablementMessaging.prototype.getApiByName = function (name) {
        return this.availableApiList[name];
    };
    return AppEnablementMessaging;
}(AppEnablement_1.AppEnablement));
exports.AppEnablementMessaging = AppEnablementMessaging;
