# App Enablement Api Overview
API consist of few modules grouped by functional point-of-view:
* Authorization
* Common
* Function
* Master Data
* POS
* Scanner

## Authorization
| Method   |      Description      |  Input parameters | Response | Since version |Note |
|----------|:-------------:|------:|:------|------:|------:|
| **getAuthorizationContext** | Provides authorization information like token or set of user rights for logged user | --- |  ```{authToken: "abcdefg",rightSet:[function1", "function2"]}```  | 2.6.0 |
| **userUnauthorizedError** | Provides information that logged user is not authorised (token expired for example) | --- |  ```{authToken: "abcdefg",rightSet:[function1", "function2"]}```  | 2.6.0 |

## Common
| Method   |      Description      |  Input parameters | Response | Since version| Note |
|----------|:-------------:|------:|:------|:------|:------|
| **getSessionContext** | Calls for context information on the current user session of the hosting client, like, for example, the user language or the tenant or store ID to which the user is logged in. | --- |  ```{businessUnitGroupID: "100000000000000001",businessUnitID: "9090", // Equivalent to store IDisoCurrencyCode: "USD",storeLanguage: "en_US",tenantID: "004",userLanguage: "zh_CN",workstationID: "107"}```  | 2.0.0 |
| **registerListener** | Registers a listener for the given event so that the app can react to that event. If passData in the request object is set to true, the function hands back the notification and the complete event including the event message. | ```{event: String, listener: String, passData: Boolean}``` |  xxx | 2.0.0 |
| **unregisterListener** | Removes the listener for the given event. | ```{ event: eventName }```|  ---  | 2.0.0 |
| **closeBrowser** | Closes the App and disposes of browser instance. | --- |  ---  | 2.1.0 |
| **hideBrowser** | Hides the App without closing it (keeps browser state, all registered listener continue to receive and handle events). | --- |  ---  | 2.1.0 |
| **getOperatorData** |Calls for information on the current operator, like, for example, the operatorID, the name of the operator and the operators current rights. | --- |  ```{operatorID: "1",workerID: "1",salutation: "Mr.",firstName: "John",lastName: "Doe",rightsSet: ["S.00000000001.00","S.00000000001.01"]}```  | 2.1.0 |
| **getLocaleSettings** | Returns current locale settings like date and time format| --- |  xxx  | 2.6.0 |**!!! Experimental !!!**|

## Function
| Method   |      Description      |  Input parameters | Response |Since version |
|----------|:-------------:|------:|:------|:------|
| **getFunctionContext** | Provide the context for function to run like _functionId_ or run parameters| --- |  ```{functionId: "123456", functionParameters: [{name: "param1", value: "value1"}]}``` | 2.6.0 |
| **getFunctionCache** | Loads data stored for current function with given key. Stored data fulfills interface [Transferable](https://developer.mozilla.org/en-US/docs/Web/API/Transferable) | ```{key: String}``` |  [Transferable](https://developer.mozilla.org/en-US/docs/Web/API/Transferable) | 2.6.0 |
| **setFunctionCache** | Saves data for current function with given key. Stored data fulfills interface [Transferable](https://developer.mozilla.org/en-US/docs/Web/API/Transferable) | ```{ key: String, value: Transferable }``` |  ```{successful: boolean}```  |  2.6.0 |
| **closeFunction** | Closes currently opened function (suicide button)  | --- |  --- | 2.6.0 |
| **launchFunction** | Launches other function, current function is called  | ```{functionId: "123456", functionParameters: [{name: "param1", value: "value1"}]}``` |  --- | 2.6.0 |
| **registerCloseInterceptor** | Register callback (interceptor) function which is called when application is about to be closed. Interceptor function returns Promise. According to result of this promise function is closed (resolve) and or not closed (reject). In case that interceptor function throw an error function is closed. Note: close interceptor is meant for intercepting close from wrapper application, so if application itself calls `closeFunction` from this API, then function will be closed without using this interceptor  | --- |  --- | 2.6.0 |

## Master Data
| Method   |      Description      |  Input parameters | Response | Since version |
|----------|:-------------:|------:|:------|:------|
| **getItemDataByID** | Provides GK master data item information for a given item ID. | IItemDataID |  ILineItem  | 2.0.0 |
| **getItemDataListByIDList** | Returns list of items for the list of given item ids (Note that only existing items are handed back; therefore, the return index of the resulting items is not the same than that of the IDs handed in). | ILineItemList |  IItemDataList  | 2.0.0 |
| **getImageUrl** | Returns the image URL for the given item ID. | IItemImgUrl |  String  | 2.0.0 |

## Messaging
| Method   |      Description      |  Input parameters | Response | Since version |Note |
|----------|:-------------:|------:|:------|------:|------:|
| **registerEventListener** | Register function to receive events from Messaging (currently Event-Service). It work similar way like scanner, you register callback and it is called every time event is received. *For the first time you'll get all messages queued for your function.*  | --- |  ```{topic: "abcdefg",headers:{id: "id", header2: "aaa"}, content: "particular event content"}``` headers are optional | 2.6.0 |
| **sendEvent** | Send event outside of the function | ```{topic: "abcdefg",headers:{id: "id", header2: "aaa"}, content: "particular event content"}``` headers are optional  |  --- | 2.6.0 |

## External master data
| Method   |      Description      |  Input parameters | Response | Since version |
|----------|:-------------:|------:|:------|:------|
| **getItemByCriteria** | Calls and hands back details of an item from an external repository. | ```{itemID: string,language?: string,isoCurrencyCode?: string}``` |  ```ILineItem``` (see the interface)  | 2.0.0 |
| **getItemListBySearchCriteria** | Calls and hands back a list of items from an external repository. | IExternalItemDataList |  ILineItemList  | 2.0.0 |
| **getImageUrl** | Provides an image URL for external items. | IExternalItemImgUrl |  String | 2.0.0 |

## POS
| Method   |      Description      |  Input parameters | Response | Since version |
|----------|:-------------:|------:|:------|:------|
| **getPOSItemInformationByID** | Returns item information for the given item ID.<br>Enriched with additional POS-specific information provided by other services like, for example, stock. | IPOSItemInformationByID |  IItemInfo  |2.0.0|
| **registerLineItem** | Registers a line item for the given item ID. <br> Register an item and thus add the item to the transaction. <br>Add items that are displayed in the app (for example, recommended items) to the transaction.  Make the client open the item information screen for the given item ID.<br>Show item details for a selected item. Thus, for example, additional information about a recommended item can be displayed.| ILineItemRegistration |  String  |2.0.0|
| **registerExternalLineItem** | Registers a line item based on external item data. Register an item and thus add the item to the transaction.<br>Add items that are displayed in the app (for example, recommended items) to the transaction.| ILineItemRegistration |  String  |2.0.0|
| **addAdditionalTransactionReport** | Allows to add an additional receipt to the current transaction in the POS. | IAdditionalTransactionReport |  String  |2.0.0|
| **getCurrentTransaction** | Provides current transaction from POS. | --- |  ITransaction  |2.0.0|
| **cancelCurrentTransaction** | Cancels current POS transaction. | ICurrentTransactionCancellation |  String  |2.0.0|
| **addTransactionExtension** | Allows to add an extension to the current transaction in the POS. | ITransactionExtensionValueRequest |  String  | 2.0.0|
| **updateTransactionExtension** | Allows to update an extension in the current transaction in the POS. | ITransactionExtensionValueRequest |  String  | 2.0.0|
| **deleteTransactionExtension** | Allows to delete an extension in the current transaction in the POS. | ITransactionExtensionRequest |  String  |2.0.0|
| **getCurrentCustomerList** | Returns all customers that are registered at the current transaction. | --- |  IRetailTransactionCustomer  |2.0.0|
| **registerCustomer** | Allows to register a customer within the current transaction in the POS. | ICustomerRegistration |  String  |2.0.0|
| **onLineItemRegistrationFinished** | Online item registration finished | --- |  String  |2.0.0|
| **getLastNotVoidedTransaction** | Get the last not voided transaction. | --- |  ICompleteTransaction  |2.0.0|
| **printReport** | This function will print the given transaction. | ITransaction |  String  |2.0.0|
| **enterCoupon** | Allows to enter a coupon to the current transaction in the POS. | ICouponRequest |  String  | 2.0.0|

## Scanner
| Method   |      Description      |  Input parameters | Response | Since version |
|----------|:-------------:|------:|:------|:------|
| **getAvailableScannerTypes** | Provides list of available scanners. Usually CAMERA and/or HW scanner.<br> Method returns empty array or null/undefined in case that scanner is not supported at all | --- |  ```["CAMERA", "HW"]```  |2.6.0|
| **openCameraScanner** | Opens camera scanner window, once some object (barcode, QR code) is scanned it return value via callback | --- |  ```{scanned: "1234567890"}```  |2.6.0|




