import * as TransactionDTO from "./ITransaction";
export * from "./ITransaction";
export interface IPOSItemInformationByID {
    itemID: string;
}
export interface IPrintAdditionalLineItemTextLine {
    text: string;
    sortOrder: string;
    styleID: string;
}
export interface IRegisterExternalLineItem {
    posItemID: string;
    itemID: string;
    posDepartmentID: string;
    unitOfMeasureCode: string;
    itemType: string;
    regularUnitPrice: string;
    actualUnitPrice: string;
    quantity: number;
    units: string;
    quantityInputMethod: string;
    length: string;
    width: string;
    height: string;
    receiptText: string;
    receiptDescription: string;
    wicFlag: boolean;
    allowFoodStampFlag: boolean;
    registrationNumber: string;
    discountFlag: boolean;
    frequentShopperPointsEligibilityFlag: boolean;
    discountTypeCode: string;
    priceChangeTypeCode: string;
    priceTypeCode: string;
    notConsideredByLoyaltyEngineFlag: boolean;
    merchandiseHierarchyGroupName: string;
    merchandiseHierarchyGroupDescription: string;
    itemClassCode: string;
    prohibitTaxExemptFlag: boolean;
    prohibitReturnFlag: boolean;
    warrantyDuration: string;
    depositTypeCode: string;
    taxExemptCode: string;
    mainPOSItemID: string;
    mainMerchandiseHierarchyGroupIDQualifier: string;
    mainMerchandiseHierarchyGroupID: string;
    taxGroupID: string;
    tareCount: string;
    saleReturnLineItemCharacteristicList: Array<ISaleReturnLineItemCharacteristic>;
    saleReturnLineItemMerchandiseHierarchyGroupList: Array<ISaleReturnLineItemMerchandiseHierarchyGroup>;
    retailTransactionLineItemI18NTextList: Array<IRetailTransactionLineItemI18NText>;
    serializedUnitModifer: ISerializedUnitModifer;
    saleReturnLineItemSalesOrder: ISaleReturnLineItemSalesOrder;
    reasonCode: string;
    reasonCodeGroupCode: string;
    reasonDescription: string;
    retailTransactionLineItemAdditionalParameterList: Array<IRetailTransactionLineItemAdditionalParameter>;
    retailPriceModifierList?: Array<IRetailPriceModifier>;
    lineItemExtensionList?: Array<ITransactionExtensionValueRequest>;
    printAdditionalLineItemTextLineList?: Array<IPrintAdditionalLineItemTextLine>;
}
export interface ISerializedUnitModifer {
    serialNumber: string;
}
export interface ISaleReturnLineItemCharacteristic {
    characteristicID: string;
    characteristicValueID: string;
    characteristicValueName: string;
}
export interface ISaleReturnLineItemMerchandiseHierarchyGroup {
    merchandiseHierarchyGroupIDQualifier: string;
    merchandiseHierarchyGroupID: string;
}
export interface IRetailTransactionLineItemI18NText {
    textSequenceNumber: number;
    languageID: string;
    category: string;
    text: string;
    pictureFlag: boolean;
}
export interface ISaleReturnLineItemSalesOrder {
    externalCustomerOrderID: string;
    customerOrderSequenceNumber: string;
    salesOrderTypeCode: string;
    salesOrderDeliveryTypeCode: string;
    requestedDeliveryDate: string;
}
export interface IRetailTransactionLineItemAdditionalParameter {
    externalParameterID: string;
    parameterName: string;
    parameterValue: string;
}
export interface IRetailPriceModifier {
    retailPriceModifierSequenceNumber: number;
    percent: string;
    amount: string;
    extendedAmountBeforeModification: string;
    extendedAmountAfterModification: string;
    appliedQuantity: string;
    triggerSequenceNumber: number;
    extraAmount: string;
    roundingAmount: string;
    calculationBaseAmount: string;
    retailTransactionPriceDerivationRule: IRetailTransactionPriceDerivationRule;
    saleReturnLineItemPromotionTriggerList: Array<ISaleReturnLineItemPromotion>;
}
export interface IRetailTransactionPriceDerivationRule {
    promotionID: number;
    priceDerivationRuleID: number;
    priceDerivationRuleEligibilityID: number;
    promotionDescription: string;
    receiptPrinterName: string;
    promotionPriceDerivationRuleSequence: number;
    promotionPriceDerivationRuleResolution: number;
    promotionPriceDerivationRuleTypeCode: string;
    priceModificationMethodCode: string;
    priceDerivationRuleDescription: string;
    promotionOriginatorTypeCode: string;
    externalPromotionID: string;
    externalPriceDerivationRuleID: string;
    triggerQuantity: string;
    giftCertificateExpirationDate: string;
    discountMethodCode: string;
    prohibitPrintFlag: string;
    tenderTypeCode: string;
    promotionTypeName: string;
    calculationBase: string;
    noEffectOnSubsequentPriceDerivationRulesFlag: string;
    prohibitTransactionRelatedPriceDerivationRulesFlag: string;
    couponPrintoutID: string;
    couponPrintoutRule: string;
    couponPrintoutText: string;
    exclusiveFlag: string;
    concurrenceControlVector: string;
    appliedCount: number;
    printoutValidityPeriod: number;
}
export interface ISaleReturnLineItemPromotion {
    triggerSequenceNumber: number;
    triggerType: string;
    triggerValue: string;
    privilegeType: string;
    privilegeValue: string;
    reasonCode: string;
    reasonDescription: string;
    triggerSequenceAddend: number;
}
export interface ILineItemRegistration {
    itemID: string;
    language?: string;
    isoCurrencyCode?: string;
    quantity: number;
    actualUnitPrice?: number;
    customerOrderID?: string;
    customerOrderSequenceNumber?: string;
    salesOrderTypeCode?: string;
    salesOrderDeliveryTypeCode?: string;
    requestedDeliveryDate?: string;
    itemType?: string;
    retailPriceModifierList?: Array<IRetailPriceModifier>;
    lineItemExtensionList?: Array<ITransactionExtensionValueRequest>;
    printAdditionalLineItemTextLineList?: Array<IPrintAdditionalLineItemTextLine>;
}
export interface ICustomerRegistration {
    customerId: string;
    customerServiceTypeCode: string;
    preferredReceiptPrintoutTypeCode: string;
}
export interface ITransactionExtensionRequest {
    extensionKey: string;
}
export interface ITransactionExtensionValueRequest extends ITransactionExtensionRequest {
    extensionValue: string;
}
export interface ICurrentTransactionCancellation {
    reasonCodeRequired: string;
    reasonCode: string;
    reasonDescription: string;
}
export interface IAdditionalTransactionReport {
    reportIdentification: string;
    printAdditionalLineItemTextLineList: Array<IPrintAdditionalLineItemTextLine>;
}
export interface IItemInfo {
    businessUnitGroupID: number;
    itemID: string;
    uomCode: string;
    name: string;
    mainPOSItemId: string;
    merchandiseHierarchyGroupName: string;
    validPriceAmount: number;
    regularPriceAmount: number;
    validPriceExpiryDate: string;
    deposit: number;
    color: string;
    size: string;
    taxGroupID: string;
    imageSrcIds: string;
    authorisedForSale: boolean;
    ePriceTypeCode: string;
    internalStock: IStockAmountDetail;
    externalStocks: Array<IStockAmountDetail>;
    itemView: IItemInformationView;
    uomItemTextList: Array<IUomItemText>;
    prices: Array<IPrice>;
    itemInfoIcons: Array<IUomItemText>;
    discountInfoIcons: Array<IDiscountIconList>;
    webshopItemInfoData: IWebshopItemInfoData;
    variantsAvailable: boolean;
}
export interface IStockAmountDetail {
    itemID: string;
    uomCode: string;
    mainPOSItemId: string;
    storeId: string;
    storeDescription: string;
    address: string;
    phoneNumber: string;
    distance: number;
    name: string;
    stock: number;
    inTransitStock: number;
    reservedStock: number;
    transferStock: number;
    freeStock: number;
    inFlow: number;
}
export interface IItemInformationView {
    validPriceAmount: string;
    regularPriceAmount: string;
    deposit: string;
    freeStock: string;
    reservedStock: string;
    transferStock: string;
    inTransitStock: string;
    validPriceExpiryDate: string;
}
export interface IUomItemText {
    index: number;
    text: string;
}
export interface IPrice {
    sequenceNumber: number;
    description: string;
    unitPrice: number;
    discountAmount: number;
    newPrice: number;
    priceQuantity: number;
    quantity: number;
    unitPriceWithCurrency: string;
    discountWithCurrency: string;
    newPriceWithCurrency: string;
    priceGroupId: string;
}
export interface IDiscountIconList {
    icon: string;
    iconDisabled: string;
    promotionId: number;
    eligibilityId: number;
    ruleId: number;
    enabled: boolean;
    overlayText: string;
    placeHolders: Array<IPlaceHolder>;
}
export interface IPlaceHolder {
    placeholder: string;
    content: string;
}
export interface IWebshopItemInfoData {
    description: string;
    name: string;
    averageRating: number;
    imageUrl: string;
    stock: string;
    code: string;
    manufacturer: string;
    price: string;
}
export interface ICompleteTransaction {
    key: ICompleteTransactionKey;
    correlatedToList: Array<TransactionDTO.ITransaction>;
    onlineChecked: boolean;
    checksum: string;
}
export interface ICompleteTransactionKey {
    transaction: TransactionDTO.ITransaction;
}
export interface ICouponRequest {
    couponNumber: string;
    privilegeType: string;
    privilegeValue: number;
}
