export interface ITransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITransactionAdditionalPrintoutKey {
    businessUnitGroupID: string;
    transactionID: string;
    printoutSequenceNumber: number;
}
export interface ITransactionAdditionalPrintout {
    key: ITransactionAdditionalPrintoutKey;
    triggerID: string;
    triggerValue: string;
    reportName: string;
    printoutCount: number;
    printoutContent: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionAssociationKey {
    businessUnitGroupID: string;
    transactionID: string;
    toTransactionID: string;
    toBusinessUnitGroupID: string;
    transactionAssociationTypeCode: string;
}
export interface ITransactionAssociation {
    key: ITransactionAssociationKey;
    toTransactionID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionBinaryDataKey {
    businessUnitGroupID: string;
    transactionID: string;
    binaryDataSequenceNumber: number;
}
export interface ITransactionBinaryData {
    key: ITransactionBinaryDataKey;
    name: string;
    content: any;
    contentLength: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionCategoryKey {
    businessUnitGroupID: string;
    transactionID: string;
    transactionCategoryCode: string;
}
export interface ITransactionCategory {
    key: ITransactionCategoryKey;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionExtensionKey {
    businessUnitGroupID: string;
    transactionID: string;
    extensionKey: string;
    extensionSequenceNumber: number;
}
export interface ITransactionExtension {
    key: ITransactionExtensionKey;
    extensionValue: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionResourceOverrideKey {
    businessUnitGroupID: string;
    transactionID: string;
    overrideSequenceNumber: number;
}
export interface ITransactionResourceOverride {
    key: ITransactionResourceOverrideKey;
    resourceID: string;
    operatorID: string;
    overrideTimestamp: string;
    entryMethodCode: string;
    approverName: string;
    approverFirstName: string;
    workGroupID: string;
    workerID: string;
    overrideTimestampUTC0: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransactionAuditEventKey {
    businessUnitGroupID: string;
    transactionID: string;
    eventSequenceNumber: number;
}
export interface ITransactionAuditEvent {
    key: ITransactionAuditEventKey;
    creationTimestamp: string;
    creationTimestampUTC0: string;
    workstationID: string;
    workstationTypeCode: string;
    eventTypeCode: string;
    content: any;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderControlTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITenderControlTransactionTenderLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderTypeCode: string;
}
export interface ITenderControlTransactionTenderLineItemDenominationKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderTypeCode: string;
    denominationSequenceNumber: number;
}
export interface ITenderControlTransactionTenderLineItemDenomination {
    key: ITenderControlTransactionTenderLineItemDenominationKey;
    typeCode: string;
    pieceValue: number;
    rollFlag: boolean;
    rollCapacity: number;
    denominationCount: number;
    denominationAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderControlTransactionTenderLineItem {
    key: ITenderControlTransactionTenderLineItemKey;
    foreignCurrencyAmount: number;
    amount: number;
    count: number;
    tenderControlTransactionTenderLineItemDenominationList: Array<ITenderControlTransactionTenderLineItemDenomination>;
    currencySymbol: string;
    tenderDescription: string;
    unitCountRequiredFlag: boolean;
    amountCountRequiredFlag: boolean;
    tenderClassCode: string;
    exchangeRate: number;
    exchangeRateMultiplyFlag: boolean;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    isocurrencyCode: string;
}
export interface ITenderPickupTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITenderPickupTransaction {
    key: ITenderPickupTransactionKey;
    inboundSafeID: string;
    outboundTillID: string;
    envelopeID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderLoanTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITenderLoanTransaction {
    key: ITenderLoanTransactionKey;
    outboundSafeID: string;
    inboundTillID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderAmountAdjustmentTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITenderAmountAdjustmentTransaction {
    key: ITenderAmountAdjustmentTransactionKey;
    tillID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderDepositReceiptTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITenderDepositReceiptTransaction {
    key: ITenderDepositReceiptTransactionKey;
    outboundTenderRepositoryID: string;
    inboundTenderRepositoryID: string;
    depositBagID: string;
    depositBagNumber: string;
    safeTenderMovementCode: string;
    doubleCheckingWorkerID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderControlTransaction {
    key: ITenderControlTransactionKey;
    tenderControlTypeCode: string;
    tenderControlTransactionTenderLineItemList: Array<ITenderControlTransactionTenderLineItem>;
    tenderPickupTransactionList: Array<ITenderPickupTransaction>;
    tenderLoanTransactionList: Array<ITenderLoanTransaction>;
    tenderAmountAdjustmentTransactionList: Array<ITenderAmountAdjustmentTransaction>;
    tenderDepositReceiptTransactionList: Array<ITenderDepositReceiptTransaction>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IRetailTransactionLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IRetailTransactionLineItemAssociationKey {
    businessUnitGroupID: string;
    transactionID: string;
    lineItemSequenceNumber: number;
    toTransactionID: string;
    toLineItemSequenceNumber: number;
    lineItemAssociationTypeCode: string;
    toBusinessUnitGroupID: string;
}
export interface IRetailTransactionLineItemAssociation {
    key: IRetailTransactionLineItemAssociationKey;
    toTransactionID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemAdditionalParameterKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    externalParameterID: string;
}
export interface IRetailTransactionLineItemAdditionalParameter {
    key: IRetailTransactionLineItemAdditionalParameterKey;
    parameterName: string;
    parameterValue: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemBinaryDataKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    binaryDataSequenceNumber: number;
}
export interface IRetailTransactionLineItemBinaryData {
    key: IRetailTransactionLineItemBinaryDataKey;
    name: string;
    content: any;
    contentLength: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemI18NTextKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    textSequenceNumber: number;
    languageID: string;
    category: string;
}
export interface IRetailTransactionLineItemI18NText {
    key: IRetailTransactionLineItemI18NTextKey;
    text: string;
    pictureFlag: boolean;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemResourceOverrideKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    resourceOverrideSequenceNumber: number;
}
export interface IRetailTransactionLineItemResourceOverride {
    key: IRetailTransactionLineItemResourceOverrideKey;
    resourceID: string;
    operatorID: string;
    overrideTimestamp: string;
    entryMethodCode: string;
    approverName: string;
    approverFirstName: string;
    workGroupID: string;
    workerID: string;
    overrideTimestampUTC0: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemExtensionKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    extensionKey: string;
    extensionSequenceNumber: number;
}
export interface IRetailTransactionLineItemExtension {
    key: IRetailTransactionLineItemExtensionKey;
    extensionValue: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemAuditEventKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    eventSequenceNumber: number;
}
export interface IRetailTransactionLineItemAuditEvent {
    key: IRetailTransactionLineItemAuditEventKey;
    creationTimestamp: string;
    creationTimestampUTC0: string;
    workstationID: string;
    workstationTypeCode: string;
    eventTypeCode: string;
    content: any;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IWorkerDiscountLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IWorkerDiscountLineItem {
    key: IWorkerDiscountLineItemKey;
    workerID: string;
    workerFirstName: string;
    workerLastName: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITaxLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ITaxLineItem {
    key: ITaxLineItemKey;
    taxIncludedInPricesFlag: boolean;
    taxAtSourceFlag: boolean;
    taxablePercent: number;
    taxableAmount: number;
    taxPercent: number;
    taxAmount: number;
    taxGroupRuleID: string;
    taxAuthorityID: string;
    taxAuthorityName: string;
    taxGroupID: string;
    receiptPrintCode: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IGiftCertificateLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IGiftCertificateLineItem {
    key: IGiftCertificateLineItemKey;
    giftCertificateHandlingTypeCode: string;
    giftCertificateTypeCode: string;
    bookingSuccessfulTypeCode: string;
    bookingCancellationTypeCode: string;
    externalSystemAdapterName: string;
    expirationDate: string;
    remainingBalance: number;
    giftCertificateSerialNumber: string;
    gcstransactionUUID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IPrepaidLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IPrepaidLineItem {
    key: IPrepaidLineItemKey;
    bookingSuccessfulTypeCode: string;
    prepaidProviderName: string;
    prepaidTransactionID: string;
    externalSystemAdapterName: string;
    prepaidID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItemFrequentShopperPointsRedemptionKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IRetailTransactionLineItemFrequentShopperPointsRedemption {
    key: IRetailTransactionLineItemFrequentShopperPointsRedemptionKey;
    customerAccountID: string;
    redemptionTransactionID: string;
    frequentShopperPointsRedeemedCount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ISaleReturnLineItemExtensionKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    extensionKey: string;
    extensionSequenceNumber: number;
}
export interface ISaleReturnLineItemExtension {
    key: ISaleReturnLineItemExtensionKey;
    extensionValue: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemCollectionKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    itemID: string;
    itemBaggingUnitOfMeasureCode: string;
}
export interface ISaleReturnLineItemCollection {
    key: ISaleReturnLineItemCollectionKey;
    quantity: number;
    units: number;
    receiptText: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemPriceKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    priceTypeCode: string;
}
export interface ISaleReturnLineItemPrice {
    key: ISaleReturnLineItemPriceKey;
    priceAmount: number;
    description: string;
    packagePriceQuantity: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnTaxLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    taxSequenceNumber: number;
}
export interface ISaleReturnTaxOverrideModifierKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    taxSequenceNumber: number;
}
export interface ISaleReturnTaxOverrideModifier {
    key: ISaleReturnTaxOverrideModifierKey;
    taxGroupRuleID: string;
    taxableAmount: number;
    originalTaxAmount: number;
    newTaxAmount: number;
    originalTaxPercent: number;
    newTaxPercent: number;
    reasonCode: string;
    reasonDescription: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnTaxLineItem {
    key: ISaleReturnTaxLineItemKey;
    taxGroupRuleID: string;
    taxIncludedInPricesFlag: boolean;
    taxAtSourceFlag: boolean;
    taxableAmount: number;
    taxablePercent: number;
    taxPercent: number;
    taxAmount: number;
    taxAuthorityID: string;
    taxAuthorityName: string;
    receiptPrintCode: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    saleReturnTaxOverrideModifierList: Array<ISaleReturnTaxOverrideModifier>;
}
export interface IRetailPriceModifierKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    retailPriceModifierSequenceNumber: number;
}
export interface IRetailPriceModifier {
    key: IRetailPriceModifierKey;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    reasonCode: string;
    previousPrice: number;
    percent: number;
    amount: number;
    calculationMethodCode: string;
    adjustmentMethodCode: string;
    newPrice: number;
    eligibilityTypeCode: string;
    extendedAmountBeforeModification: number;
    extendedAmountAfterModification: number;
    appliedQuantity: number;
    triggerSequenceNumber: number;
    reasonDescription: string;
    extraAmount: number;
    roundingAmount: number;
    externalSystemOriginatorFlag: boolean;
    prorateFrom: number;
    calculationBaseAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IFrequentShopperPointsModifierKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    frequentShopperPointsModifierSequenceNumber: number;
}
export interface IFrequentShopperPointsModifier {
    key: IFrequentShopperPointsModifierKey;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    triggerSequenceNumber: number;
    eligibilityTypeCode: string;
    frequentShopperPointsEarnedCount: number;
    frequentShopperPointsEarnedAmount: number;
    appliedQuantity: number;
    computationBaseAmount: number;
    externalSystemOriginatorFlag: boolean;
    prorateFrom: number;
    pointsPercentage: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemPromotionTriggerKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    triggerSequenceNumber: number;
}
export interface ISaleReturnLineItemPromotionTrigger {
    key: ISaleReturnLineItemPromotionTriggerKey;
    triggerType: string;
    triggerValue: string;
    privilegeType: string;
    privilegeValue: number;
    reasonCode: string;
    reasonDescription: string;
    reference_: string;
    triggerSequenceAddend: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemCharacteristicKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    characteristicID: string;
}
export interface ISaleReturnLineItemCharacteristic {
    key: ISaleReturnLineItemCharacteristicKey;
    characteristicValueID: string;
    characteristicValueName: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemModifierCouponKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    modifierSequenceNumber: number;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    couponSequenceNumber: number;
}
export interface ISaleReturnLineItemModifierCoupon {
    key: ISaleReturnLineItemModifierCouponKey;
    couponNumber: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemModifierReferenceKey {
    businessUnitGroupID: string;
    transactionID: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ISaleReturnLineItemModifierReference {
    key: ISaleReturnLineItemModifierReferenceKey;
    referenceQuantity: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemMerchandiseHierarchyGroupKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    merchandiseHierarchyGroupIDQualifier: string;
    merchandiseHierarchyGroupID: string;
}
export interface ISaleReturnLineItemMerchandiseHierarchyGroup {
    key: ISaleReturnLineItemMerchandiseHierarchyGroupKey;
    timeStampEffective: string;
    timeStampExpiration: string;
    statusCode: string;
    timeStampEffectiveUTC0: string;
    timeStampExpirationUTC0: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IFoodServiceLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IFoodServiceLineItem {
    key: IFoodServiceLineItemKey;
    tableID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IFuelSalesLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IFuelSalesLineItem {
    key: IFuelSalesLineItemKey;
    fuelSaleStatusCode: string;
    fuelGradeID: string;
    unitPrice: number;
    fuelingPointID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemAdditionalPriceKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    priceTypeCode: string;
}
export interface ISaleReturnLineItemAdditionalPrice {
    key: ISaleReturnLineItemAdditionalPriceKey;
    priceAmount: number;
    packagePriceQuantity: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemSplitPackageKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    splitPrice: number;
}
export interface ISaleReturnLineItemSplitPackage {
    key: ISaleReturnLineItemSplitPackageKey;
    splitQuantity: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IReturnLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IReturnLineItem {
    key: IReturnLineItemKey;
    returnReasonCode: string;
    returnReasonDescription: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItemSalesOrderKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ISaleReturnLineItemSalesOrder {
    key: ISaleReturnLineItemSalesOrderKey;
    salesOrderTypeCode: string;
    salesOrderDeliveryTypeCode: string;
    requestedDeliveryDate: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISerializedUnitModiferKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ISerializedUnitModifer {
    key: ISerializedUnitModiferKey;
    serializedItemID: string;
    serialNumber: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ILineItemAssociateKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ILineItemAssociate {
    key: ILineItemAssociateKey;
    workerID: string;
    actionDatetime: string;
    workerFirstName: string;
    workerLastName: string;
    actionDatetimeUTC0: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnTaxExemptTriggerKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ISaleReturnTaxExemptTrigger {
    key: ISaleReturnTaxExemptTriggerKey;
    reasonCode: string;
    reasonDescription: string;
    taxCertificateID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISaleReturnLineItem {
    key: ISaleReturnLineItemKey;
    itemID: string;
    unitOfMeasureCode: string;
    itemType: string;
    subItemType: string;
    regularUnitPrice: number;
    regularUnitPriceQuantity: number;
    actualUnitPrice: number;
    actualUnitPriceQuantity: number;
    quantity: number;
    units: number;
    extendedAmount: number;
    extendedDiscountAmount: number;
    sellUnitRetailPriceEntryMethodCode: string;
    actionCode: string;
    reasonCode: string;
    itemTraceableUnitID: string;
    quantityInputMethod: string;
    length: number;
    width: number;
    height: number;
    manualWeightInputFlag: boolean;
    receiptText: string;
    receiptDescription: string;
    allowFoodStampFlag: boolean;
    registrationNumber: string;
    negativeLineItemFlag: boolean;
    discountFlag: boolean;
    frequentShopperPointsEligibilityFlag: boolean;
    discountTypeCode: string;
    priceChangeTypeCode: string;
    priceTypeCode: string;
    grandExtendedAmount: number;
    reasonCodeGroupCode: string;
    reasonDescription: string;
    notConsideredByLoyaltyEngineFlag: boolean;
    merchandiseHierarchyGroupName: string;
    merchandiseHierarchyGroupDescription: string;
    itemClassCode: string;
    prohibitTaxExemptFlag: boolean;
    prohibitReturnFlag: boolean;
    warrantyDuration: number;
    depositTypeCode: string;
    taxExemptCode: string;
    invoiceID: string;
    mainPOSItemID: string;
    mainMerchandiseHierarchyGroupIDQualifier: string;
    mainMerchandiseHierarchyGroupID: string;
    taxReductionAmount: number;
    taxGroupID: string;
    taxReceiptPrintCode: string;
    tareCount: number;
    originalTaxGroupID: string;
    manufacturerFamilyCode: string;
    manufacturerCompanyCode: string;
    priceGroupID: string;
    saleReturnLineItemExtensionList: Array<ISaleReturnLineItemExtension>;
    saleReturnLineItemCollectionList: Array<ISaleReturnLineItemCollection>;
    saleReturnLineItemPriceList: Array<ISaleReturnLineItemPrice>;
    saleReturnTaxLineItemList: Array<ISaleReturnTaxLineItem>;
    retailPriceModifierList: Array<IRetailPriceModifier>;
    frequentShopperPointsModifierList: Array<IFrequentShopperPointsModifier>;
    saleReturnLineItemPromotionTriggerList: Array<ISaleReturnLineItemPromotionTrigger>;
    saleReturnLineItemCharacteristicList: Array<ISaleReturnLineItemCharacteristic>;
    saleReturnLineItemModifierCouponList: Array<ISaleReturnLineItemModifierCoupon>;
    saleReturnLineItemModifierReferenceList: Array<ISaleReturnLineItemModifierReference>;
    saleReturnLineItemMerchandiseHierarchyGroupList: Array<ISaleReturnLineItemMerchandiseHierarchyGroup>;
    externalReferenceID: string;
    foodServiceLineItem: IFoodServiceLineItem;
    fuelSalesLineItem: IFuelSalesLineItem;
    saleReturnLineItemAdditionalPriceList: Array<ISaleReturnLineItemAdditionalPrice>;
    saleReturnLineItemSplitPackageList: Array<ISaleReturnLineItemSplitPackage>;
    positemID: string;
    posdepartmentID: string;
    wicflag: boolean;
    returnLineItemList: Array<IReturnLineItem>;
    saleReturnLineItemSalesOrderList: Array<ISaleReturnLineItemSalesOrder>;
    serializedUnitModiferList: Array<ISerializedUnitModifer>;
    lineItemAssociateList: Array<ILineItemAssociate>;
    saleReturnTaxExemptTriggerList: Array<ISaleReturnTaxExemptTrigger>;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ICheckTenderLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ICheckTenderLineItem {
    key: ICheckTenderLineItemKey;
    fullMICR: string;
    checkSequenceNumber: number;
    adjudicationCode: string;
    checkCardNumber: string;
    bankID: string;
    checkAccountNumber: string;
    bankIdentifierCode: string;
    internationalBankAccountNumber: string;
    checkNumber: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderLineItem {
    key: ITenderLineItemKey;
    isChangeFlag: boolean;
    tenderTypeCode: string;
    tenderAccountNumber: string;
    foreignCurrencyAmount: number;
    exchangeRate: number;
    tenderAmount: number;
    tenderGroupCode: string;
    tenderCount: number;
    tenderDescription: string;
    cashbackFlag: boolean;
    foreignISOCurrencyCode: string;
    exchangeRateMultiplyFlag: boolean;
    currencySymbol: string;
    tipAmount: number;
    tipForeignCurrencyAmount: number;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    checkTenderLineItemList: Array<ICheckTenderLineItem>;
}
export interface IVoidsLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IVoidsLineItem {
    key: IVoidsLineItemKey;
    voidsLineItemSequenceNumber: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRoundingLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IRoundingLineItem {
    key: IRoundingLineItemKey;
    roundUpFlag: boolean;
    amount: number;
    typeCode: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IPriceModificationLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface IPriceModificationLineItem {
    key: IPriceModificationLineItemKey;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    percentage: number;
    roundingAmount: number;
    amount: number;
    proRatedFlag: boolean;
    triggerSequenceNumber: number;
    extendedAmountBeforeModification: number;
    extendedAmountAfterModification: number;
    extraAmount: number;
    externalSystemOriginatorFlag: boolean;
    calculationBaseAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ILoyaltyRewardLineItemKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
}
export interface ILoyaltyRewardLineItemCouponSerialKey {
    businessUnitGroupID: string;
    transactionID: string;
    retailTransactionLineItemSequenceNumber: number;
    couponSerialSequenceNumber: number;
}
export interface ILoyaltyRewardLineItemCouponSerial {
    key: ILoyaltyRewardLineItemCouponSerialKey;
    couponSerialNumber: string;
    bookingSuccessfulTypeCode: string;
    bookingTransactionUUID: string;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    xxcustom16: string;
    xxcustom17: string;
    xxcustom18: string;
    xxcustom19: string;
    xxcustom20: string;
    xxcustom21: string;
    xxcustom22: string;
    xxcustom23: string;
    xxcustom24: string;
    xxcustom25: string;
    xxcustom26: string;
    xxcustom27: string;
    xxcustom28: string;
    xxcustom29: string;
    xxcustom30: string;
}
export interface ILoyaltyRewardLineItem {
    key: ILoyaltyRewardLineItemKey;
    pointsAwardedCount: number;
    loyaltyRewardTypeCode: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    frequentShopperPointsEarnedAmount: number;
    triggerSequenceNumber: number;
    computationBaseAmount: number;
    externalSystemOriginatorFlag: boolean;
    couponNumber: string;
    couponAmount: number;
    giftCertificateFaceValueAmount: number;
    pointsPercentage: number;
    loyaltyRewardLineItemCouponSerialList: Array<ILoyaltyRewardLineItemCouponSerial>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionLineItem {
    key: IRetailTransactionLineItemKey;
    externalCustomerOrderID: string;
    customerOrderSequenceNumber: number;
    beginDateTimestamp: string;
    voidFlag: boolean;
    endDateTimestamp: string;
    entryMethodCode: string;
    retailTransactionLineItemTypeCode: string;
    voidTypeCode: string;
    workstationID: string;
    workstationTypeCode: string;
    keyedOfflineCode: string;
    beginDateTimestampUTC0: string;
    endDateTimestampUTC0: string;
    retailTransactionLineItemAssociationList: Array<IRetailTransactionLineItemAssociation>;
    retailTransactionLineItemAdditionalParameterList: Array<IRetailTransactionLineItemAdditionalParameter>;
    retailTransactionLineItemBinaryDataList: Array<IRetailTransactionLineItemBinaryData>;
    retailTransactionLineItemI18NTextList: Array<IRetailTransactionLineItemI18NText>;
    retailTransactionLineItemResourceOverrideList: Array<IRetailTransactionLineItemResourceOverride>;
    retailTransactionLineItemExtensionList: Array<IRetailTransactionLineItemExtension>;
    retailTransactionLineItemAuditEventList: Array<IRetailTransactionLineItemAuditEvent>;
    workerDiscountLineItemList: Array<IWorkerDiscountLineItem>;
    taxLineItemList: Array<ITaxLineItem>;
    giftCertificateLineItemList: Array<IGiftCertificateLineItem>;
    prepaidLineItemList: Array<IPrepaidLineItem>;
    retailTransactionLineItemFrequentShopperPointsRedemptionList: Array<IRetailTransactionLineItemFrequentShopperPointsRedemption>;
    saleReturnLineItemList: Array<ISaleReturnLineItem>;
    tenderLineItemList: Array<ITenderLineItem>;
    voidsLineItemList: Array<IVoidsLineItem>;
    roundingLineItemList: Array<IRoundingLineItem>;
    priceModificationLineItemList: Array<IPriceModificationLineItem>;
    loyaltyRewardLineItemList: Array<ILoyaltyRewardLineItem>;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionTotalKey {
    businessUnitGroupID: string;
    transactionID: string;
    transactionTotalTypeCode: string;
}
export interface IRetailTransactionTotal {
    key: IRetailTransactionTotalKey;
    amount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionPromotionTriggerKey {
    businessUnitGroupID: string;
    transactionID: string;
    triggerSequenceNumber: number;
}
export interface IRetailTransactionPromotionTrigger {
    key: IRetailTransactionPromotionTriggerKey;
    triggerType: string;
    triggerValue: string;
    privilegeType: string;
    privilegeValue: number;
    reasonCode: string;
    reasonDescription: string;
    reference_: string;
    triggerSequenceAddend: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionExternalTriggerKey {
    businessUnitGroupID: string;
    transactionID: string;
    triggerTypeCode: string;
}
export interface IRetailTransactionExternalTrigger {
    key: IRetailTransactionExternalTriggerKey;
    triggerAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCustomerKey {
    businessUnitGroupID: string;
    transactionID: string;
    customerID: string;
    addressTypeCode: string;
}
export interface IRetailTransactionCustomerAccountKey {
    businessUnitGroupID: string;
    transactionID: string;
    customerID: string;
    addressTypeCode: string;
    customerAccountSequenceNumber: number;
}
export interface IRetailTransactionCustomerAccount {
    key: IRetailTransactionCustomerAccountKey;
    customerAccountID: string;
    customerAccountTypeCode: string;
    customerAccountBalance: number;
    customerAccountQuerySuccessfulFlag: boolean;
    customerAccountTransactionID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCustomerGroupAssignmentKey {
    businessUnitGroupID: string;
    transactionID: string;
    customerID: string;
    addressTypeCode: string;
    customerGroupID: string;
}
export interface IRetailTransactionCustomerGroupAssignment {
    key: IRetailTransactionCustomerGroupAssignmentKey;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCustomerContactMethodKey {
    businessUnitGroupID: string;
    transactionID: string;
    customerID: string;
    addressTypeCode: string;
    contactPurposeTypeCode: string;
    contactMethodTypeCode: string;
}
export interface IRetailTransactionCustomerContactMethod {
    key: IRetailTransactionCustomerContactMethodKey;
    contactTypeCode: string;
    emailAddressLocalPart: string;
    emailAddressDomainPart: string;
    completePhoneNumber: string;
    internetURL: string;
    addressLine1: string;
    addressLine2: string;
    addressLine3: string;
    addressLine4: string;
    addressLine5: string;
    city: string;
    subTerritoryName: string;
    postalCode: string;
    postalCodeExtension: string;
    territory: string;
    territoryName: string;
    isocountryCode: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCustomerIdentificationKey {
    businessUnitGroupID: string;
    transactionID: string;
    customerID: string;
    addressTypeCode: string;
    partyIdentificationTypeCode: string;
}
export interface IRetailTransactionCustomerIdentification {
    key: IRetailTransactionCustomerIdentificationKey;
    identifier: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCustomer {
    key: IRetailTransactionCustomerKey;
    genderType: string;
    birthDayNumber: number;
    birthMonthNumber: number;
    birthYearNumber: number;
    addressTypeDescription: string;
    genericFlag: boolean;
    businessDescription: string;
    customerIDEntryMethodCode: string;
    firstName: string;
    lastName: string;
    preferredReceiptPrintoutTypeCode: string;
    parentCustomerID: string;
    parentCustomerName1: string;
    parentCustomerName2: string;
    retailTransactionCustomerAccountList: Array<IRetailTransactionCustomerAccount>;
    retailTransactionCustomerGroupAssignmentList: Array<IRetailTransactionCustomerGroupAssignment>;
    retailTransactionCustomerContactMethodList: Array<IRetailTransactionCustomerContactMethod>;
    retailTransactionCustomerIdentificationList: Array<IRetailTransactionCustomerIdentification>;
    organizationName: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionCouponSummaryKey {
    businessUnitGroupID: string;
    transactionID: string;
    couponNumber: string;
}
export interface IRetailTransactionCouponSerialSummaryKey {
    businessUnitGroupID: string;
    transactionID: string;
    couponNumber: string;
    couponSerialNumber: string;
}
export interface IRetailTransactionCouponSerialSummary {
    key: IRetailTransactionCouponSerialSummaryKey;
    bookingSuccessfulTypeCode: string;
    bookingTransactionUUID: string;
    expirationTimestamp: string;
    expirationTimestampUTC0: string;
    appliedFlag: boolean;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    xxcustom16: string;
    xxcustom17: string;
    xxcustom18: string;
    xxcustom19: string;
    xxcustom20: string;
    xxcustom21: string;
    xxcustom22: string;
    xxcustom23: string;
    xxcustom24: string;
    xxcustom25: string;
    xxcustom26: string;
    xxcustom27: string;
    xxcustom28: string;
    xxcustom29: string;
    xxcustom30: string;
}
export interface IRetailTransactionCouponSummary {
    key: IRetailTransactionCouponSummaryKey;
    inputCount: number;
    appliedCount: number;
    privilegeType: string;
    privilegeValue: number;
    customerID: string;
    customerAddressTypeCode: string;
    retailTransactionCouponSerialSummaryList: Array<IRetailTransactionCouponSerialSummary>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionPromotionPriceDerivationRuleKey {
    businessUnitGroupID: string;
    transactionID: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
}
export interface IRetailTransactionPromotionExternalActionTextKey {
    businessUnitGroupID: string;
    transactionID: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    textID: string;
    languageID: string;
}
export interface IRetailTransactionPromotionExternalActionText {
    key: IRetailTransactionPromotionExternalActionTextKey;
    text: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionPromotionExternalActionParameterKey {
    businessUnitGroupID: string;
    transactionID: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    parameterID: string;
}
export interface IRetailTransactionPromotionExternalActionParameter {
    key: IRetailTransactionPromotionExternalActionParameterKey;
    parameterValue: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionPromotionPriceDerivationRule {
    key: IRetailTransactionPromotionPriceDerivationRuleKey;
    promotionDescription: string;
    receiptPrinterName: string;
    promotionPriceDerivationRuleSequence: string;
    promotionPriceDerivationRuleResolution: string;
    promotionPriceDerivationRuleTypeCode: string;
    transactionControlBreakCode: string;
    priceModificationMethodCode: string;
    priceDerivationRuleDescription: string;
    promotionOriginatorTypeCode: string;
    externalPromotionID: string;
    externalPriceDerivationRuleID: string;
    triggerQuantity: number;
    giftCertificateExpirationDate: string;
    discountMethodCode: string;
    frequentShopperPointsFlag: boolean;
    customerGroupLoyaltyPointsDefaultQuantity: number;
    prohibitPrintFlag: boolean;
    tenderTypeCode: string;
    promotionTypeName: string;
    calculationBase: string;
    pointsConversionAmount: number;
    noEffectOnSubsequentPriceDerivationRulesFlag: boolean;
    prohibitTransactionRelatedPriceDerivationRulesFlag: boolean;
    couponPrintoutID: string;
    couponPrintoutRule: string;
    couponPrintoutText: any;
    exclusiveFlag: boolean;
    requireUserInteractionFlag: boolean;
    considerPreviousPriceDerivationRulesFlag: boolean;
    concurrenceControlVector: string;
    appliedCount: number;
    printoutValidityPeriod: number;
    externalActionID: string;
    externalActionDescription: string;
    externalActionTextList: Array<IRetailTransactionPromotionExternalActionText>;
    externalActionParameterList: Array<IRetailTransactionPromotionExternalActionParameter>;
    calculationBaseSequence: string;
    externalOfferID: string;
    additionalPriceTypeCode: string;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionModifierCouponKey {
    businessUnitGroupID: string;
    transactionID: string;
    promotionID: string;
    priceDerivationRuleID: string;
    priceDerivationRuleEligibilityID: string;
    couponSequenceNumber: number;
}
export interface IRetailTransactionModifierCoupon {
    key: IRetailTransactionModifierCouponKey;
    couponNumber: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITenderAuthorizationKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderAuthorizationSequenceNumber: number;
}
export interface ITenderAuthorization {
    key: ITenderAuthorizationKey;
    tenderLineItemSequenceNumber: number;
    cardType: string;
    accountNumber: string;
    cardIssueSequenceNumber: string;
    cardExpirationDate: string;
    referenceNumber: string;
    terminalTransactionStatus: number;
    terminalTransactionErrorNumber: number;
    terminalTransactionType: number;
    forceOnlineFlag: boolean;
    requestedAmount: number;
    authorizationDatetime: string;
    terminalTransactionEndTimestamp: string;
    relatedTenderAuthorizatonSequenceNumber: number;
    terminalSequenceNumber: string;
    requestedISOCurrencyNumber: string;
    cardHolderVerificationTypeCode: string;
    tenderAuthorizationTerminalID: number;
    traceNumber: number;
    terminalType: string;
    merchantNumber: string;
    approvalCode: string;
    adjudicationCode: string;
    adjudicationText: string;
    hostAuthorizedFlag: boolean;
    activationSequenceNumber: number;
    terminalTransactionReferenceNumber: string;
    terminalTransactionTypeCode: string;
    terminalTenderDescription: string;
    applicationID: string;
    encryptedPAN: string;
    terminalTransactionCurrencyCode: string;
    authorizationDatetimeUTC0: string;
    terminalTransactionEndTimestampUTC0: string;
    terminalTransactionToken: string;
    internationalBankAccountNumber: string;
    bankIdentifierCode: string;
    creditorID: string;
    mandateID: string;
    prenotificationText: string;
    tenderAuthorizationTerminalID2: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionManufacturerCouponSummaryKey {
    businessUnitGroupID: string;
    transactionID: string;
    manufacturerCouponScanCode: string;
}
export interface IRetailTransactionManufacturerCouponValidationKey {
    businessUnitGroupID: string;
    transactionID: string;
    manufacturerCouponScanCode: string;
    saleLineItemSequenceNumber: number;
}
export interface IRetailTransactionManufacturerCouponValidation {
    key: IRetailTransactionManufacturerCouponValidationKey;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionManufacturerCouponSummary {
    key: IRetailTransactionManufacturerCouponSummaryKey;
    manufacturerCompanyCode: string;
    manufacturerOfferCode: string;
    keyEnteredFlag: boolean;
    inputCount: number;
    appliedCount: number;
    appliedIntervalCount: number;
    totalAmount: number;
    tenderLineItemSequenceNumber: number;
    saleLineItemValidationList: Array<IRetailTransactionManufacturerCouponValidation>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransactionTaxExemptTriggerKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IRetailTransactionTaxExemptTrigger {
    key: IRetailTransactionTaxExemptTriggerKey;
    reasonCode: string;
    reasonDescription: string;
    taxCertificateID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IRetailTransaction {
    key: IRetailTransactionKey;
    retailTransactionTypeCode: string;
    tillID: string;
    receiptDateTime: string;
    receiptPrintoutFlag: boolean;
    promotionTimestamp: string;
    frequentShopperLostPointsCount: number;
    retailTransactionLineItemList: Array<IRetailTransactionLineItem>;
    retailTransactionTotalList: Array<IRetailTransactionTotal>;
    retailTransactionPromotionTriggerList: Array<IRetailTransactionPromotionTrigger>;
    retailTransactionExternalTriggerList: Array<IRetailTransactionExternalTrigger>;
    retailTransactionCustomerList: Array<IRetailTransactionCustomer>;
    retailTransactionCouponSummaryList: Array<IRetailTransactionCouponSummary>;
    retailTransactionPromotionPriceDerivationRuleList: Array<IRetailTransactionPromotionPriceDerivationRule>;
    retailTransactionModifierCouponList: Array<IRetailTransactionModifierCoupon>;
    tenderAuthorizationList: Array<ITenderAuthorization>;
    retailTransactionManufacturerCouponSummaryList: Array<IRetailTransactionManufacturerCouponSummary>;
    emailRequestedFlag: boolean;
    emailAddressLocalPart: string;
    emailAddressDomainPart: string;
    invoicePrintoutTypeCode: string;
    invoiceNumber: string;
    receiptDateTimeUTC0: string;
    promotionTimestampUTC0: string;
    retailTransactionTaxExemptTriggerList: Array<IRetailTransactionTaxExemptTrigger>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IControlTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IFuelingTransactionKey {
    transactionID: string;
    businessUnitGroupID: string;
}
export interface IFuelingTransaction {
    key: IFuelingTransactionKey;
    itemID: string;
    fuelingPointID: string;
    nozzleID: string;
    typeCode: string;
    timeStamp: string;
    timeStampUTC0: string;
    volume: number;
    unitPrice: number;
    authorizationElapsedTime: number;
    deliveryElapsedTime: number;
    saleElapsedTime: number;
    fuelGradeID: string;
    unitOfMeasureCode: string;
    fleetCardPermissionTypeCode: string;
    testDeliveryTypeCode: string;
    driveOffTypeCode: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IPOSNoSaleTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IPOSNoSaleTransaction {
    key: IPOSNoSaleTransactionKey;
    tillID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISignOnTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ISignOnTransaction {
    key: ISignOnTransactionKey;
    tillID: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ISignOffTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ISignOffTransaction {
    key: ISignOffTransactionKey;
    tillID: string;
    lastWorkstationID: string;
    lastWorkerID: string;
    lastWorkerFirstName: string;
    lastWorkerLastName: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITillTenderSettlementTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITillSettlementTenderDetailKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderRepositoryID: string;
    tenderTypeCode: string;
}
export interface ITillSettlementTenderDenominationKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderRepositoryID: string;
    tenderTypeCode: string;
    denominationSequenceNumber: number;
}
export interface ITillSettlementTenderDenomination {
    key: ITillSettlementTenderDenominationKey;
    typeCode: string;
    pieceValue: number;
    rollFlag: boolean;
    rollCapacity: number;
    denominationCount: number;
    denominationAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITillSettlementTenderDetail {
    key: ITillSettlementTenderDetailKey;
    openBalanceAmount: number;
    openMediaUnitQuantity: number;
    closeBalanceAmount: number;
    closeMediaUnitQuantity: number;
    countedBalanceAmount: number;
    countedMediaUnitQuantity: number;
    overUnderBalanceAmount: number;
    overUnderMediaUnitQuantity: number;
    currencySymbol: string;
    tenderDescription: string;
    unitCountRequiredFlag: boolean;
    amountCountRequiredFlag: boolean;
    tenderClassCode: string;
    exchangeRate: number;
    exchangeRateMultiplyFlag: boolean;
    foreignCurrencyCountedBalanceAmount: number;
    foreignCurrencyCloseBalanceAmount: number;
    tillSettlementTenderDenominationList: Array<ITillSettlementTenderDenomination>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    isocurrencyCode: string;
}
export interface ITillSettlementDocumentKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderRepositoryID: string;
}
export interface ITillSettlementDocument {
    key: ITillSettlementDocumentKey;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITillTenderSettlementTransaction {
    key: ITillTenderSettlementTransactionKey;
    tillSettlementTenderDetailList: Array<ITillSettlementTenderDetail>;
    tillSettlementDocumentList: Array<ITillSettlementDocument>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IStoreSafeSettlementTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IStoreSafeSettlementTenderDetailKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderRepositoryID: string;
    tenderTypeCode: string;
}
export interface IStoreSafeSettlementTenderDenominationKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderRepositoryID: string;
    tenderTypeCode: string;
    denominationSequenceNumber: number;
}
export interface IStoreSafeSettlementTenderDenomination {
    key: IStoreSafeSettlementTenderDenominationKey;
    typeCode: string;
    pieceValue: number;
    rollFlag: boolean;
    rollCapacity: number;
    denominationCount: number;
    denominationAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IStoreSafeSettlementTenderDetail {
    key: IStoreSafeSettlementTenderDetailKey;
    openBalanceAmount: number;
    openMediaUnitQuantity: number;
    closeBalanceAmount: number;
    closeMediaUnitQuantity: number;
    countedBalanceAmount: number;
    countedMediaUnitQuantity: number;
    overUnderBalanceAmount: number;
    overUnderMediaUnitQuantity: number;
    currencySymbol: string;
    tenderDescription: string;
    unitCountRequiredFlag: boolean;
    amountCountRequiredFlag: boolean;
    tenderClassCode: string;
    exchangeRate: number;
    exchangeRateMultiplyFlag: boolean;
    foreignCurrencyCountedBalanceAmount: number;
    foreignCurrencyCloseBalanceAmount: number;
    storeSafeSettlementTenderDenominationList: Array<IStoreSafeSettlementTenderDenomination>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    isocurrencyCode: string;
}
export interface IStoreSafeSettlementTransaction {
    key: IStoreSafeSettlementTransactionKey;
    storeSafeSettlementTenderDetailList: Array<IStoreSafeSettlementTenderDetail>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IDepositBagTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IDepositBagTransaction {
    key: IDepositBagTransactionKey;
    depositBagID: string;
    depositBagNumber: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IDepositBagSettlementTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface IDepositBagSettlementTenderDetailKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderTypeCode: string;
}
export interface IDepositBagSettlementTenderDenominationKey {
    businessUnitGroupID: string;
    transactionID: string;
    tenderTypeCode: string;
    denominationSequenceNumber: number;
}
export interface IDepositBagSettlementTenderDenomination {
    key: IDepositBagSettlementTenderDenominationKey;
    typeCode: string;
    pieceValue: number;
    rollFlag: boolean;
    rollCapacity: number;
    denominationCount: number;
    denominationAmount: number;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IDepositBagSettlementTenderDetail {
    key: IDepositBagSettlementTenderDetailKey;
    tenderDescription: string;
    tenderClassCode: string;
    currencySymbol: string;
    exchangeRate: number;
    exchangeRateMultiplyFlag: boolean;
    unitCountRequiredFlag: boolean;
    amountCountRequiredFlag: boolean;
    openBalanceAmount: number;
    openMediaUnitQuantity: number;
    closeBalanceAmount: number;
    foreignCurrencyCloseBalanceAmount: number;
    closeMediaUnitQuantity: number;
    countedBalanceAmount: number;
    foreignCurrencyCountedBalanceAmount: number;
    countedMediaUnitQuantity: number;
    overUnderBalanceAmount: number;
    overUnderMediaUnitQuantity: number;
    depositBagSettlementTenderDenominationList: Array<IDepositBagSettlementTenderDenomination>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    isocurrencyCode: string;
}
export interface IDepositBagSettlementTransaction {
    key: IDepositBagSettlementTransactionKey;
    depositBagID: string;
    depositBagNumber: string;
    depositBagSettlementTenderDetailList: Array<IDepositBagSettlementTenderDetail>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITaxRefundTransactionKey {
    businessUnitGroupID: string;
    transactionID: string;
}
export interface ITaxRefundTransaction {
    key: ITaxRefundTransactionKey;
    taxRefundDocumentID: string;
    externalTransactionID: string;
    storeInvoiceID: string;
    totalGrossAmount: number;
    totalTaxAmount: number;
    totalRefundAmount: number;
    taxRefundServiceProviderName: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface IControlTransaction {
    key: IControlTransactionKey;
    typeCode: string;
    fuelingTransaction: IFuelingTransaction;
    posnoSaleTransactionList: Array<IPOSNoSaleTransaction>;
    signOnTransactionList: Array<ISignOnTransaction>;
    signOffTransactionList: Array<ISignOffTransaction>;
    tillTenderSettlementTransactionList: Array<ITillTenderSettlementTransaction>;
    storeSafeSettlementTransactionList: Array<IStoreSafeSettlementTransaction>;
    depositBagTransactionList: Array<IDepositBagTransaction>;
    depositBagSettlementTransactionList: Array<IDepositBagSettlementTransaction>;
    taxRefundTransactionList: Array<ITaxRefundTransaction>;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
}
export interface ITransaction {
    key: ITransactionKey;
    operatorID: string;
    workstationID: string;
    businessUnitID: string;
    businessDayDate: string;
    sequenceNumber: number;
    transactionTypeCode: string;
    beginDateTimestamp: string;
    endDateTimestamp: string;
    cancelledFlag: boolean;
    suspendedFlag: boolean;
    trainingFlag: boolean;
    keyedOfflineFlag: string;
    reasonCode: string;
    reasonDescription: string;
    workerID: string;
    workerFirstName: string;
    workerLastName: string;
    softwareVersion: string;
    suspendNumber: string;
    internalSequenceNumber: number;
    fiscalSequenceNumber: string;
    fiscalFlag: boolean;
    fiscalDayNumber: string;
    fiscalPrinterID: string;
    fiscalSignature: string;
    transactionTimestamp: string;
    beginDateTimestampUTC0: string;
    endDateTimestampUTC0: string;
    transactionTimestampUTC0: string;
    transactionAdditionalPrintoutList: Array<ITransactionAdditionalPrintout>;
    transactionAssociationList: Array<ITransactionAssociation>;
    transactionBinaryDataList: Array<ITransactionBinaryData>;
    transactionCategoryList: Array<ITransactionCategory>;
    transactionExtensionList: Array<ITransactionExtension>;
    transactionResourceOverrideList: Array<ITransactionResourceOverride>;
    endWorkstationID: string;
    transactionAuditEventList: Array<ITransactionAuditEvent>;
    tenderControlTransactionList: Array<ITenderControlTransaction>;
    retailTransactionList: Array<IRetailTransaction>;
    controlTransactionList: Array<IControlTransaction>;
    xxcustom06: string;
    xxcustom07: string;
    xxcustom08: string;
    xxcustom09: string;
    xxcustom10: string;
    xxcustom11: string;
    xxcustom12: string;
    xxcustom13: string;
    xxcustom14: string;
    xxcustom15: string;
    xxcustom01: string;
    xxcustom02: string;
    xxcustom03: string;
    xxcustom04: string;
    xxcustom05: string;
    isocurrencyCode: string;
}
