import * as PosDto from "./PosApiDTO";
import { ApiResponse } from "../ApiResponse";
import { IGkApi } from "../IGkApi";
export interface IPosApi extends IGkApi {
    getPOSItemInformationByID: (appCallback: ApiResponse<PosDto.IItemInfo>, data: PosDto.IPOSItemInformationByID) => void;
    registerLineItem: (appCallback: ApiResponse<string>, data: PosDto.ILineItemRegistration) => void;
    registerExternalLineItem: (appCallback: ApiResponse<string>, data: PosDto.IRegisterExternalLineItem) => void;
    addAdditionalTransactionReport: (appCallback: ApiResponse<string>, data: PosDto.IAdditionalTransactionReport) => void;
    getCurrentTransaction: (appCallback: ApiResponse<PosDto.ITransaction>) => void;
    cancelCurrentTransaction: (appCallback: ApiResponse<string>, data: PosDto.ICurrentTransactionCancellation) => void;
    addTransactionExtension: (appCallback: ApiResponse<string>, data: PosDto.ITransactionExtensionValueRequest) => void;
    updateTransactionExtension: (appCallback: ApiResponse<string>, data: PosDto.ITransactionExtensionValueRequest) => void;
    deleteTransactionExtension: (appCallback: ApiResponse<string>, data: PosDto.ITransactionExtensionRequest) => void;
    getCurrentCustomerList: (appCallback: ApiResponse<PosDto.IRetailTransactionCustomer>) => void;
    registerCustomer: (appCallback: ApiResponse<string>, data: PosDto.ICustomerRegistration) => void;
    onLineItemRegistrationFinished: (appCallback: ApiResponse<string>) => void;
    getLastNotVoidedTransaction: (appCallback: ApiResponse<PosDto.ICompleteTransaction>) => void;
    printReport: (appCallback: ApiResponse<string>, data: PosDto.ITransaction) => void;
    enterCoupon: (appCallback: ApiResponse<string>, data: PosDto.ICouponRequest) => void;
    getPosContext: (appCallback: ApiResponse<string>) => void;
}
