export interface IItemDataID {
    itemID: string;
}
export interface IItemDataList {
    itemIDList: Array<string>;
}
export interface IItemImgUrl {
    itemID: string;
    type: string;
}
export interface IExternalItemDataID {
    itemID: string;
    language?: string;
    isoCurrencyCode?: string;
}
export interface IExternalItemImgUrl {
    itemID: string;
    type: string;
    language?: string;
    isoCurrencyCode?: string;
}
export interface IExternalItemDataList {
    query: string;
    recordCount: number;
    language?: string;
    isoCurrencyCode?: string;
}
export interface ILineItemKey {
    businessUnitGroupID: string;
    itemID: string;
    uomCode: string;
}
export interface ILineItemList {
    data: Array<ILineItem>;
}
export interface IItemCollection {
    key: {
        memberItemId: string;
        memberUOMCode: string;
    };
    quantity: number;
}
export interface IRelatedItemAssociation {
    key: {
        relatedItemId: string;
        associationTypeCode: string;
    };
}
export interface IItemCharacteristic {
    key: {
        characteristicId: string;
        characteristicValueId: string;
    };
}
export interface IItemFeatureList {
    key: {
        featureCode: string;
        characteristicValueId: string;
    };
    featureValue: string;
}
export interface IPosIdentityList {
    key: {
        posItemId: string;
    };
    posIdentityTypeCode: string;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface ISellingPriceList {
    key: {
        businessUnitGroupID: string;
        itemID: string;
        uomCode: string;
        priceTypeCode: string;
        priceEffectiveDate: string;
    };
    priceExpirationDate: string;
    priceAmount: number;
    packagePriceQuantity: number;
    priceGroupId: string;
    description: string;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface IItemSellingRule {
    itemSellingRuleId?: string;
    priceEntryRequiredFlag?: boolean;
    prohibitReturnFlag?: boolean;
    allowFoodStampFlag?: boolean;
    wicFlag?: boolean;
    fsaCode?: string;
    deliveryStockAssortmentFlag?: boolean;
    retainPrepaymentFlag?: boolean;
    takeAwayAllowedFlag?: boolean;
    serialNumberRequiredFlag?: boolean;
    taxExemptProbihitedFlag?: boolean;
    authorisedForSaleFlag?: boolean;
    discountFlag?: boolean;
    bonusPointsFlag?: boolean;
    quantityInputTypeCode?: string;
    quantityInputMethod?: string;
    sellingEffectiveDate?: string;
    sellingExpirationDate?: string;
    negativePositionFlag?: boolean;
    priceChangeTypeCode?: string;
    hidePriceFlag?: boolean;
    showItemOnCustomerDisplayFlag?: boolean;
    barCodeHandlingMethod?: string;
    weightEntryRequiredFlag?: boolean;
    priceEntryOnScalesAllowedFlag?: boolean;
    allowLayawayFlag?: boolean;
    layawayDiscountFlag?: boolean;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface IItemDepositCollectionList {
    key: {
        memberItemId: string;
        memberUOMCode: string;
    };
    perAssemblyCount: number;
}
export interface IUomItemTextList {
    key: {
        textNumber: number;
        textClass: string;
        languageId: string;
    };
    text: string;
    pictureFlag: boolean;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface IItemMHGList {
    key: {
        merchandiseHierarchyGroupId: string;
    };
    merchandiseHierarchyGroupIDQualifier: string;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface IMerchandiseHierarchyGroupAssignment {
    merchandiseHierarchyGroupID: string;
}
export interface IUnitOfMeasureItemAssignment {
    itemID: string;
    unitOfMeasureCode: string;
}
export interface ITranslation {
    languageID: string;
    questionText: string;
}
export interface ISalesRestriction {
    salesRestrictionID: string;
    salesRestrictionValue: string;
    SalesRestrictionTypeCode: string;
    merchandiseHierarchyGroupAssignmentList: Array<IMerchandiseHierarchyGroupAssignment>;
    unitOfMeasureItemAssignmentList: Array<IUnitOfMeasureItemAssignment>;
    questionText: string;
    questionTypeCode: string;
    tid: string;
    translationList: Array<ITranslation>;
    XX_CUSTOM_19?: string;
    XX_CUSTOM_01?: string;
    XX_CUSTOM_03?: string;
    XX_CUSTOM_04?: string;
    XX_CUSTOM_02?: string;
    XX_CUSTOM_06?: string;
    XX_CUSTOM_07?: string;
    XX_CUSTOM_05?: string;
    XX_CUSTOM_13?: string;
    XX_CUSTOM_08?: string;
    XX_CUSTOM_09?: string;
    XX_CUSTOM_11?: string;
    XX_CUSTOM_12?: string;
    XX_CUSTOM_10?: string;
    XX_CUSTOM_14?: string;
    XX_CUSTOM_17?: string;
    XX_CUSTOM_15?: string;
    XX_CUSTOM_23?: string;
    XX_CUSTOM_25?: string;
    XX_CUSTOM_24?: string;
    XX_CUSTOM_21?: string;
    XX_CUSTOM_26?: string;
    XX_CUSTOM_29?: string;
    XX_CUSTOM_28?: string;
    XX_CUSTOM_27?: string;
    XX_CUSTOM_30?: string;
    XX_CUSTOM_22?: string;
    XX_CUSTOM_16?: string;
    XX_CUSTOM_18?: string;
    XX_CUSTOM_20?: string;
}
export interface IPriceContractRead {
    priceContractID: string;
    itemID: string;
    posItemID: string;
    unitOfMeasureCode: string;
    effectiveDateTime: string;
    expirationDateTime: string;
    saleUnitRetailPriceAmount: number;
    customerID: string;
    customerGroupID: string;
}
export interface ILineItem {
    key?: ILineItemKey;
    name?: string;
    description?: string;
    classCode?: string;
    taxGroupID?: string;
    alternativeTaxGroupID?: string;
    itemUsageTypeCode?: string;
    taxExemptCode?: string;
    warrantyPeriod?: number;
    tareId?: number;
    tareUomCode?: string;
    posDepartmentID?: string;
    mainPOSItemId?: string;
    mainMerchandiseHierarchyGroupID?: string;
    depositTypeCode?: string;
    itemSellingRule?: IItemSellingRule;
    statusCode?: string;
    itemCollectionList?: Array<IItemCollection>;
    relatedItemAssociationList?: Array<IRelatedItemAssociation>;
    itemCharacteristicList?: Array<IItemCharacteristic>;
    itemFeatureList?: Array<IItemFeatureList>;
    posIdentityList?: Array<IPosIdentityList>;
    sellingPriceList?: Array<ISellingPriceList>;
    itemDepositCollectionList?: Array<IItemDepositCollectionList>;
    uomItemTextList?: Array<IUomItemTextList>;
    itemMHGList?: Array<IItemMHGList>;
    salesRestrictionList?: Array<ISalesRestriction>;
    updateStockFlag?: boolean;
    baseUOMCode?: string;
    prohibitedForPhysicalInventoryFlag?: boolean;
    minimumShelfLifeDayCount?: number;
    labelType?: string;
    discountTypeCode?: string;
    globalLifeDayCount?: number;
    shelfLifeDayCountPercent?: number;
    dayCountUOMCode?: string;
    defaultReceivingLocation?: string;
    concessionItemFlag?: boolean;
    costItemFlag?: boolean;
    merchandisePlanningTypeCode?: string;
    mainSupplierId?: string;
    venSafeFlag?: boolean;
    baseUOMConsumerPackageGrossContent?: number;
    baseUOMConsumerPackageNetContent?: number;
    baseUOMConsumerPackageContentsUOMCode?: string;
    baseUOMConsumerPackageBasePriceContent?: number;
    baseUOMConsumerPackageBasePriceContentsUOMCode?: string;
    distributingWarehouseID?: string;
    distributionMethodID?: string;
    assortmentID?: string;
    thirdPartyAssortmentID?: string;
    transportAssociationID?: string;
    concessionItemSupplierID?: string;
    defaultSellingUOMCode?: string;
    conversionNumerator?: number;
    conversionDenominator?: number;
    consumerPackageGrossWeight?: number;
    consumerPackageNetWeight?: number;
    consumerPackageWeightUOMCode?: string;
    consumerPackageVolume?: number;
    consumerPackageVolumeUOMCode?: string;
    consumerPackageDepth?: number;
    consumerPackageWidth?: number;
    consumerPackageHeight?: number;
    consumerPackageSizeUOMCode?: string;
    outerPackageTypeCode?: string;
    headOfficeCarryRequirementTypeCode?: string;
    handlingTypeCode?: string;
    statusEffectiveDate?: string;
    maximumStockQuantity?: number;
    minimumStockQuantity?: number;
    listingEffectiveDate?: string;
    listingExpirationDate?: string;
    priceContractReadList?: Array<IPriceContractRead>;
    selectedPriceContractRead?: IPriceContractRead;
    HSNCode?: string;
    ITEM_XX_CUSTOM_01?: string;
    ITEM_XX_CUSTOM_02?: string;
    ITEM_XX_CUSTOM_03?: string;
    ITEM_XX_CUSTOM_04?: string;
    ITEM_XX_CUSTOM_05?: string;
    ITEM_XX_CUSTOM_06?: string;
    ITEM_XX_CUSTOM_07?: string;
    ITEM_XX_CUSTOM_08?: string;
    ITEM_XX_CUSTOM_09?: string;
    ITEM_XX_CUSTOM_10?: string;
    ITEM_XX_CUSTOM_11?: string;
    ITEM_XX_CUSTOM_12?: string;
    ITEM_XX_CUSTOM_13?: string;
    ITEM_XX_CUSTOM_14?: string;
    ITEM_XX_CUSTOM_15?: string;
    ITEM_XX_CUSTOM_16?: string;
    ITEM_XX_CUSTOM_17?: string;
    ITEM_XX_CUSTOM_18?: string;
    ITEM_XX_CUSTOM_19?: string;
    ITEM_XX_CUSTOM_20?: string;
    ITEM_XX_CUSTOM_21?: string;
    ITEM_XX_CUSTOM_22?: string;
    ITEM_XX_CUSTOM_23?: string;
    ITEM_XX_CUSTOM_24?: string;
    ITEM_XX_CUSTOM_25?: string;
    ITEM_XX_CUSTOM_26?: string;
    ITEM_XX_CUSTOM_27?: string;
    ITEM_XX_CUSTOM_28?: string;
    ITEM_XX_CUSTOM_29?: string;
    ITEM_XX_CUSTOM_30?: string;
    UOM_ITEM_XX_CUSTOM_01?: string;
    UOM_ITEM_XX_CUSTOM_02?: string;
    UOM_ITEM_XX_CUSTOM_03?: string;
    UOM_ITEM_XX_CUSTOM_04?: string;
    UOM_ITEM_XX_CUSTOM_05?: string;
    UOM_ITEM_XX_CUSTOM_06?: string;
    UOM_ITEM_XX_CUSTOM_07?: string;
    UOM_ITEM_XX_CUSTOM_08?: string;
    UOM_ITEM_XX_CUSTOM_09?: string;
    UOM_ITEM_XX_CUSTOM_10?: string;
    UOM_ITEM_XX_CUSTOM_11?: string;
    UOM_ITEM_XX_CUSTOM_12?: string;
    UOM_ITEM_XX_CUSTOM_13?: string;
    UOM_ITEM_XX_CUSTOM_14?: string;
    UOM_ITEM_XX_CUSTOM_15?: string;
    UOM_ITEM_XX_CUSTOM_16?: string;
    UOM_ITEM_XX_CUSTOM_17?: string;
    UOM_ITEM_XX_CUSTOM_18?: string;
    UOM_ITEM_XX_CUSTOM_19?: string;
    UOM_ITEM_XX_CUSTOM_20?: string;
    UOM_ITEM_XX_CUSTOM_21?: string;
    UOM_ITEM_XX_CUSTOM_22?: string;
    UOM_ITEM_XX_CUSTOM_23?: string;
    UOM_ITEM_XX_CUSTOM_24?: string;
    UOM_ITEM_XX_CUSTOM_25?: string;
    UOM_ITEM_XX_CUSTOM_26?: string;
    UOM_ITEM_XX_CUSTOM_27?: string;
    UOM_ITEM_XX_CUSTOM_28?: string;
    UOM_ITEM_XX_CUSTOM_29?: string;
    UOM_ITEM_XX_CUSTOM_30?: string;
}
