import { ApiResponse } from "../ApiResponse";
import { IGkApi } from "../IGkApi";
import { IFunctionCacheData, IFunctionCacheWriteStatus, IFunctionContext } from "./FunctionApiDTO";
export interface IFunctionApi extends IGkApi {
    getFunctionContext: (appCallback: ApiResponse<IFunctionContext>) => void;
    getFunctionCache: (appCallback: ApiResponse<Transferable>, data: IFunctionCacheData) => void;
    setFunctionCache: (appCallback: ApiResponse<IFunctionCacheWriteStatus>, data: IFunctionCacheData) => void;
    closeFunction: () => void;
    launchFunction: (functionContext: IFunctionContext) => void;
    registerCloseInterceptor: (closeInterceptor: () => Promise<void>) => void;
}
