import { IContext, ILocaleSettings, IOperator } from "./CommonApiDTO";
import { ApiResponse } from "../ApiResponse";
import { IGkApi } from "../IGkApi";
export interface ICommonApi extends IGkApi {
    getSessionContext: (appCallback: ApiResponse<IContext>) => void;
    registerListener: (eventHandler: (data: any) => void, eventName: string, registrationId: string, expectData: boolean) => void;
    unregisterListener: (eventName: string, registrationId: string) => void;
    closeBrowser: () => void;
    hideBrowser: () => void;
    getOperatorData: (appCallback: ApiResponse<IOperator>) => void;
    getLocaleSettings: (appCallback: ApiResponse<ILocaleSettings>) => void;
}
